/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.datasource.db;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObjectNode;
import de.willuhn.datasource.db.AbstractDBObject;
import de.willuhn.datasource.db.DBIteratorImpl;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.datasource.rmi.DBObject;
import de.willuhn.datasource.rmi.DBObjectNode;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.ArrayList;

public abstract class AbstractDBObjectNode
extends AbstractDBObject
implements DBObjectNode {
    protected String getNodeField() {
        return "parent_id";
    }

    @Override
    public GenericIterator getChildren() throws RemoteException {
        if (this.isNewObject()) {
            return PseudoIterator.fromArray(new GenericObjectNode[0]);
        }
        DBIterator list = this.getList();
        list.addFilter(this.getNodeField() + " = " + this.getID());
        return list;
    }

    @Override
    public GenericIterator getTopLevelList() throws RemoteException {
        DBIterator list = this.getList();
        list.addFilter(this.getNodeField() + " is null");
        return list;
    }

    @Override
    public boolean hasChild(GenericObjectNode object) throws RemoteException {
        if (object == null) {
            return false;
        }
        GenericIterator childs = this.getChildren();
        int count = 1;
        GenericObjectNode child = null;
        while (childs.hasNext()) {
            if (++count > 10000) {
                Logger.error((String)("max recursion limit reached for [" + this.getTableName() + ":" + this.getID() + "]"));
                return false;
            }
            child = (GenericObjectNode)childs.next();
            if (child.equals(object)) {
                return true;
            }
            if (!child.hasChild(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GenericObjectNode getParent() throws RemoteException {
        DBIterator list = this.getList();
        Object parent = this.getAttribute(this.getNodeField());
        if (parent == null) {
            return null;
        }
        if (parent instanceof DBObject) {
            parent = ((DBObject)parent).getID();
        }
        list.addFilter(this.getIDField() + "=" + parent);
        if (!list.hasNext()) {
            return null;
        }
        return (GenericObjectNode)list.next();
    }

    @Override
    public GenericIterator getPossibleParents() throws RemoteException {
        DBIterator list = this.getList();
        if (!this.isNewObject()) {
            list.addFilter(this.getIDField() + " != " + this.getID());
        }
        ArrayList<String> array = new ArrayList<String>();
        GenericObjectNode element = null;
        while (list.hasNext()) {
            element = (GenericObjectNode)list.next();
            if (this.hasChild(element)) continue;
            array.add(element.getID());
        }
        return new DBIteratorImpl<AbstractDBObjectNode>(this, array, this.getService());
    }

    @Override
    public GenericIterator getPath() throws RemoteException {
        ArrayList<String> objectArray = new ArrayList<String>();
        boolean reached = false;
        GenericObjectNode currentObject = this.getParent();
        if (currentObject == null) {
            return new DBIteratorImpl<AbstractDBObjectNode>(this, objectArray, this.getService());
        }
        objectArray.add(currentObject.getID());
        GenericObjectNode object = null;
        while (!reached) {
            object = currentObject.getParent();
            if (object != null) {
                objectArray.add(object.getID());
                currentObject = object;
                continue;
            }
            reached = true;
        }
        return new DBIteratorImpl<AbstractDBObjectNode>(this, objectArray, this.getService());
    }

    @Override
    protected void deleteCheck() throws ApplicationException {
        try {
            GenericIterator list = this.getChildren();
            if (list.hasNext()) {
                throw new ApplicationException("Objekt kann nicht gel\u00f6scht werden da Abh\u00e4ngigkeiten existieren.");
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while checking children", (Throwable)e);
            throw new ApplicationException("Fehler beim Pr\u00fcfen der Abh\u00e4ngigkeiten.");
        }
    }

    @Override
    protected void insertCheck() throws ApplicationException {
        try {
            GenericObjectNode parent = this.getParent();
            if (parent == null) {
                return;
            }
            GenericIterator parents = this.getPossibleParents();
            while (parents.hasNext()) {
                GenericObjectNode node = (GenericObjectNode)parents.next();
                if (!node.equals(parent)) continue;
                return;
            }
            throw new ApplicationException("Angegebenes Eltern-Objekt nicht erlaubt");
        }
        catch (RemoteException e) {
            Logger.error((String)"error while checking children", (Throwable)e);
            throw new ApplicationException("Fehler beim Pr\u00fcfen der Abh\u00e4ngigkeiten.");
        }
    }

    @Override
    protected void updateCheck() throws ApplicationException {
        this.insertCheck();
    }

    @Override
    public void setParent(DBObjectNode parent) throws RemoteException {
        this.setAttribute(this.getNodeField(), parent);
    }
}

